function [ZLPNorm,ZLPVAR,ZLPLog] = Align3DZLP(handles,ZLP,ZLPEnergies,ZLPDrift,Back,ZLPLog)
%% Align ZLP
% As ZLP subtraction and Deconvolution require the ZLP to be aligned to the
% data as good as possible, it is aligned here.

global tracer

if isempty(tracer)
    tracer=1;
else
    ZLPNorm = [];
    ZLPVAR  = [];
    ZLPLog  = [];
    clearvars -except ZLPNorm ZLPVAR ZLPLog
    return
end

%% Load data
Add         = load(fullfile(tempdir,'Add.mat')).Add;
MeasImage   = load(fullfile(tempdir,'ShowOrg.mat')).image;
MeasImage   = cat(3,MeasImage,Add);
MeasImage   = reshape(MeasImage,[size(MeasImage,1)*size(MeasImage,2),size(MeasImage,3)]);
MeasImage   = mean(MeasImage,1);

if ~isempty(Add)
    LengthAdd = size(Add,3);
else
    LengthAdd = 0;
end
clearvars Add

%% Get handles
ImgEnergies = get(handles.ZLPAlign,'UserData');
FWHM        = get(handles.ShowFWHM,'UserData');
EnergyRes   = ZLPEnergies(2)-ZLPEnergies(1);

%% Get Noise parameters
Gain         = str2double(get(handles.GainVal,'String'));
Corrs        = get(handles.PSF,'UserData');
ReadStd      = str2double(get(handles.ReadStd,'String'));
A            = round(sqrt(size(ZLP,1)*size(ZLP,2)));

%% Calculate Phi-value
ZLPDrift  = round(ZLPDrift./EnergyRes);
SizeX     = size(ZLPDrift,2);
SizeY     = size(ZLPDrift,1);
ZLPDrift  = reshape(ZLPDrift,[1,SizeX*SizeY]);
Sum       = 0;
Size      = SizeX*SizeY;
n         = Size*(Size-1);

while Size>1
    Test       = ZLPDrift(1,1);
    ZLPDrift(:,1) = [];
    Diff       = min(abs(ZLPDrift-Test),1);
    Sum        = Sum + sum(Diff,2).*2;
    Size       = size(ZLPDrift,2);
end

Phi  = Sum/n;
clearvars ZLPDrift a

%% Shift Peaks

Back         = find(ZLPEnergies>=Back,1,'first');
[~,EnergyPos]= min(ImgEnergies.^2);
[~,EnergyZLP]= min(ZLPEnergies.^2);
a            = EnergyZLP-EnergyPos;
if a<0
    EndPoint   = repmat(mean(ZLP(:,:,1:5),3),[1,1,-a]);
    StartSlope = circshift(ZLP,-1,3)-ZLP;
    Range      = min(Back,100);
    StartSlope = mean(StartSlope(:,:,1:Range),3);
    
    FirstAdd   = repmat(reshape(linspace(-a,1,-a),[1,1,-a]),[size(ZLP,1),size(ZLP,2),1]) .*repmat(StartSlope,[1,1,-a]);
    Offset     = EndPoint - repmat(FirstAdd(:,:,end),[1,1,-a]);
    FirstAdd   = FirstAdd+Offset;
elseif a>0
    ZLP      = circshift(ZLP,-a,3);
    ZLP      = ZLP(:,:,1:end-a);
    FirstAdd = [];
else
    FirstAdd = [];
end


%% Padding
% As the DataCube is padded, the ZLP can be different in length. To
% compensate for the difference, the ZLP can be cut or padded, too.
% The difference in hight between start and end of the spectrum
% is used to  build a ramp between both, with the slope depending on the
% length of the padding.

if ~isempty(FirstAdd)
    Diff     = (size(ImgEnergies,2) + LengthAdd)-size(ZLP,3)-size(FirstAdd,3);
    SizeZLP  = size(ZLP,3) + size(FirstAdd,3);
    SizeData = size(ImgEnergies,2) + LengthAdd;
    SizeTot  = SizeData-size(FirstAdd,3);
else
    Diff= (size(ImgEnergies,2) + LengthAdd)-size(ZLP,3);
    SizeZLP  = size(ZLP,3);
    SizeData = size(ImgEnergies,2) + LengthAdd;
    SizeTot  = SizeData;
end

if SizeZLP < SizeData
    EndPoint   = repmat(mean(ZLP(:,:,end-5:end),3),[1,1,Diff]);
    StartSlope = circshift(ZLP,-1,3)-ZLP;
    StartSlope = mean(StartSlope(:,:,end-60:end),3);
    
    LastAdd    = repmat(reshape(linspace(1,1,Diff),[1,1,Diff]),[size(ZLP,1),size(ZLP,2),1]) .*repmat(StartSlope,[1,1,Diff]);
    Offset     = EndPoint - repmat(LastAdd(:,:,1),[1,1,Diff]);
    LastAdd    = LastAdd+Offset;
elseif SizeZLP > SizeData
    ZLP       = ZLP(:,:,1:SizeTot);
    LastAdd   = [];
else
    LastAdd   = [];
end

if ~isempty(FirstAdd)
    ZLP       = cat(3,FirstAdd,ZLP);
end
if ~isempty(LastAdd)
    ZLP       = cat(3,ZLP,LastAdd);
end

StartPoint = repmat(mean(ZLP(:,:,1:50),3),[1,1,round(LengthAdd/2)]);

PaddingFunc = repmat(reshape(cos(linspace(0,pi/2,round(LengthAdd/2))),[1,1,round(LengthAdd/2)]),[size(ZLP,1),size(ZLP,2),1]);
PaddingFunc(:,:,end-round(LengthAdd/4)+1:end) = PaddingFunc(:,:,end-round(LengthAdd/4)+1:end) .* repmat(reshape(cos(linspace(0,pi/2,round(LengthAdd/4))),[1,1,round(LengthAdd/4)]),[size(ZLP,1),size(ZLP,2),1]);

ZLP(:,:,end-round(LengthAdd/2)+1:end) = (ZLP(:,:,end-round(LengthAdd/2)+1:end)-StartPoint ).* PaddingFunc +StartPoint ;
Func                                  = 1 - PaddingFunc;
ZLP(:,:,end-round(LengthAdd/2)+1:end) =  ZLP(:,:,end-round(LengthAdd/2)+1:end) + Func ;
ZLP(:,:,end-round(LengthAdd/2)+1:end) = imnoise(ZLP(:,:,end-round(LengthAdd/2)+1:end)*10^-(12)./Gain,'poisson')*10^(12)*Gain;
ZLP(:,:,end-round(LengthAdd/2)+1:end) =  ZLP(:,:,end-round(LengthAdd/2)+1:end) + randn(size(ZLP(:,:,end-round(LengthAdd/2)+1:end))).*ReadStd;

%% Mean ZLP
ZLP      = reshape(ZLP,[SizeX.*SizeY,size(ZLP,3)]);
ZLP      = sum(ZLP,1); 
ZLPMax   = max(ZLP,[],2);
ZLPVAR   = Gain.*ZLP + SizeX.*SizeY.*(1+Phi/A).*ReadStd.^2;

ZLPNorm  = ZLP./ZLPMax;
ZLPVAR   = ZLPVAR./ZLPMax.^2;

%% Align Measurement and vacuum ZLP
answer = questdlg('Fine-Align vacuum ZLP to measurement?','Yes','No');
switch answer
    case 'Yes'
        
        %% Select ZLP region
        % Allows the user to select a region in which all ZLP are to be found for
        % faster alignment and to make the process less prone to cosmic rays.
        FWHM     = FWHM./EnergyRes;
        Channels = 1:size(MeasImage,2);
        
        fig  = figure('Name','Select region with ZLP - double click to confirm!');
        plot(Channels,MeasImage,'Color','b');
        hold on
        plot(Channels,zeros(size(Channels)),'--','Color','k');                     % dotted zero line
        hold off
        legend('mean Spectrum');
        ylabel( 'Counts' );
        xlabel( 'Loss energy [eV]' );
        maxEne   = max(MeasImage,[],2);
        minEne   = min(MeasImage,[],2);
        zlp      = (minEne + maxEne) / 10;
        index1   = (find(MeasImage >= zlp, 1, 'first'));
        index2   = (find(MeasImage >= zlp, 1, 'last'));
        Start    = Channels(index1)- mean(FWHM,'all')*2;
        Width    = Channels(index2)- Start + mean(FWHM,'all')*2;
        Start    = max(Start,Channels(1));
        if Start+Width > Channels(end)
            Width = Channels(end)-Start;
        end
        ylim([-max(MeasImage)/2,max(MeasImage).*1.25]);
        xlim([Start,Start+Width]);
        
        try
            Select  = drawrectangle('Position',[Start,-max(MeasImage)/2,Width,max(MeasImage)/2+max(MeasImage).*1.25],'Color','b','StripeColor','w');
            l       = addlistener(Select,'ROIClicked',@(src,evt) DoubleClicker(src,evt));
            uiwait;
            pos     = Select.Position;
            Ind1    = pos(1);
            Ind2    = pos(1)+pos(3);
            clearvars pos
            Ind1    = find(Channels>=Ind1,1,'first');
            Ind2    = find(Channels<=Ind2,1,'last');
            delete(Select);
            close(fig);
            delete(l);
            [CF,Lag]     = CrossAlign(MeasImage(:,Ind1:Ind2),MeasImage(:,Ind1:Ind2));
            [~,MaxPos]   = max(CF,[],2);
            Lag          = Lag-Lag(MaxPos);
            [CorrFunc,~] = CrossAlign(ZLPNorm(:,Ind1:Ind2),MeasImage(:,Ind1:Ind2));
            Shift        = zeros([2,1]);
            options      = optimset('Display','off');
            
            ZLP_old   = ZLPNorm;
            
            for i=1:size(CorrFunc,1)
                x           = [ max(CorrFunc(i,:)) , 0 ,mean(FWHM,'all')*2./(2*sqrt(2*log(2)))];
                eqn         = @(x) sum((x(1).*exp(-((Lag-real(x(2)))./(sqrt(2).*x(3))).^2) - CorrFunc(i,:)).^2);
                x           = fminsearch(eqn,x,options);
                Shift       = real(x(2));
                RShift      = round(Shift);
                SShift      = Shift-RShift;
                ZLPNorm(i,:) = circshift(ZLPNorm(i,:),-RShift,2);
                ZLPNorm(i,:) = interp1(Channels-SShift,ZLPNorm(i,:),Channels);
            end
            ZLPNorm(isnan(ZLPNorm)) = ZLP_old(isnan(ZLPNorm));
            
            BetaConv     = Corrs{1,3};
            BetaCorr     = Corrs{1,4};
            Beta         = BetaConv.*BetaCorr;
            BetaD        = 2/3;
            
            ZLPVAR       = Gain.*ZLP + SizeX.*SizeY.*(1+Phi/A).*ReadStd.^2;
            ZLPVAR       = ZLPVAR./ZLPMax.^2;
        catch
            answer='No';
        end
    otherwise
end

%% AlignSpecLog
ZLPLog{end+1,1} = 'Align ZLP: ';
if strcmp(answer,'Yes')
    ZLPLog{end+1,1} = ['Vacuum ZLP fine aligned to measurement: Shift: ',num2str(Shift),' Channels | Fit ROI: ', num2str(ImgEnergies(Ind1)),' eV to ', num2str(ImgEnergies(Ind2)),' eV!'];
end

clearvars -except ZLPNorm ZLPVAR ZLPLog
end